;------------------------------------------------------------------------------
; Used constants:
;
; C_WORLDTOSCREEN = world to screen matrix
;------------------------------------------------------------------------------
xvs.1.1

#include "ShadersConst.h"

#define V_POS        v0   ; position
#define V_COLOR      v1   ; color
#define V_NORM       v2   ; normal
#define V_TEX        v3   ; texcoords 1
#define V_TEX2       v4   ; texcoords 1
#define V_BONES_IDX  v5   ; bone idx
#define V_WEIGHTS    v6   ; blend weights for each bone

; Transform position and normal for bone0 matrix
mov a0.x, V_BONES_IDX.x

dp4 r2.x, V_POS, c[a0.x+0]
dp4 r2.y, V_POS, c[a0.x+1]
dp4 r2.z, V_POS, c[a0.x+2]

dp3 r3.x, V_NORM, c[a0.x+0]
dp3 r3.y, V_NORM, c[a0.x+1]
dp3 r3.z, V_NORM, c[a0.x+2]

mul r0.xyz, r2.xyz, V_WEIGHTS.x
mul r1.xyz, r3.xyz, V_WEIGHTS.x

; Transform position and normal for bone1 matrix
mov a0.x, V_BONES_IDX.y

dp4 r2.x, V_POS, c[a0.x+0]
dp4 r2.y, V_POS, c[a0.x+1]
dp4 r2.z, V_POS, c[a0.x+2]

dp3 r3.x, V_NORM, c[a0.x+0]
dp3 r3.y, V_NORM, c[a0.x+1]
dp3 r3.z, V_NORM, c[a0.x+2]

mad r0.xyz, r2.xyz, V_WEIGHTS.y, r0.xyz
mad r1.xyz, r3.xyz, V_WEIGHTS.y, r1.xyz

; Transform position and normal for bone2 matrix
mov a0.x, V_BONES_IDX.z

dp4 r2.x, V_POS, c[a0.x+0]
dp4 r2.y, V_POS, c[a0.x+1]
dp4 r2.z, V_POS, c[a0.x+2]

dp3 r3.x, V_NORM, c[a0.x+0]
dp3 r3.y, V_NORM, c[a0.x+1]
dp3 r3.z, V_NORM, c[a0.x+2]

mad r0.xyz, r2.xyz, V_WEIGHTS.z, r0.xyz
mad r1.xyz, r3.xyz, V_WEIGHTS.z, r1.xyz

; Transform position and normal for bone3 matrix
mov a0.x, V_BONES_IDX.w

dp4 r2.x, V_POS, c[a0.x+0]
dp4 r2.y, V_POS, c[a0.x+1]
dp4 r2.z, V_POS, c[a0.x+2]

dp3 r3.x, V_NORM, c[a0.x+0]
dp3 r3.y, V_NORM, c[a0.x+1]
dp3 r3.z, V_NORM, c[a0.x+2]

mad r0.xyz, r2.xyz, V_WEIGHTS.w, r0.xyz
mad r1.xyz, r3.xyz, V_WEIGHTS.w, r1.xyz

mov r0.w, C_ONE

; Transform the vertex to screen space
; The WORLDTOSCREEN matrix has to be transposed before.
dp4 oPos.x, r0, c[C_WORLDTOSCREEN+0]
dp4 oPos.y, r0, c[C_WORLDTOSCREEN+1]
dp4 oPos.z, r0, c[C_WORLDTOSCREEN+2]
dp4 oPos.w, r0, c[C_WORLDTOSCREEN+3]

; If we use that, we don't need to transpose the LOCALTOSCREEN matrix.
;mul r1, c[C_WORLDTOSCREEN+0], r0.x
;mad r1, c[C_WORLDTOSCREEN+1], r0.y, r1
;mad r1, c[C_WORLDTOSCREEN+2], r0.z, r1
;mad r1, c[C_WORLDTOSCREEN+3], r0.w, r1
;mov oPos, r1

mov	oD0, V_COLOR
mov oT0.xy, V_TEX.xy
mov oT1.xy, V_TEX2.xy
